<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use App\Models\Permission;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('permissions', function (Blueprint $table) {
            $table->id();
            $table->string('name', 151);
            $table->string('attribute')->nullable();
            $table->mediumText('keywords')->nullable();
            $table->timestamps();
        });

        $attributes = [
            'dashboard' => [
                'dashboard' => 'admin.dashboard',
            ],
            'email' => [
                'server_configuration' => 'email.server-configuration',
                'update_server_configuration' => 'email.server-configuration.update',
                'test_email' => 'email.test',
                'template' => 'email.template',
                'update_template' => 'email.template.update',
            ],
            'movies' => [
                'view' => 'admin.movies',
                'add' => 'admin.movie.add',
                'store' => 'admin.movie.store',
                'delete' => 'admin.movie.delete',
                'edit' => 'admin.movie.edit',
                'update' => 'admin.movie.update',
                'uploads_view' => 'admin.movie.upload.downloads',
                'file_add' => 'admin.movie.file.add',
                'file_store' => 'admin.movie.file.store',
                'file_delete' => 'admin.movie.file.delete',
                'file_edit' => 'admin.movie.file.edit',
                'file_update' => 'admin.movie.file.update',
                'make_rental' => 'admin.make.rental',
                'make_rental_store' => 'admin.make.rent.store',
            ],
            'downloads' => [
                'view' => 'admin.download.links',
                'add' => 'admin.download.link.add',
                'store' => 'admin.download_link.store',
                'edit' => 'admin.download_link.edit',
                'update' => 'admin.download_link.update',
                'delete' => 'admin.download_link.delete',
                'status' => 'admin.download_link.status',
            ],
            'categories' => [
                'view' => 'admin.categories',
                'add' => 'admin.category.add',
                'store' => 'admin.category.store',
                'delete' => 'admin.category.delete',
                'edit' => 'admin.category.edit',
                'update' => 'admin.category.update',
                'primary_status' => 'admin.category.primary.status',
                'footer_status' => 'admin.category.footer.status',
            ],
            'tv_shows' => [
                'view' => 'admin.tv.shows',
                'add' => 'admin.tv.show.add',
                'store' => 'admin.tv.show.store',
                'delete' => 'admin.tv.show.delete',
                'edit' => 'admin.tv.show.edit',
                'update' => 'admin.tv.show.update',
                'settings' => 'admin.tv.show.settings',
                'config' => 'admin.tv.show.config',
            ],
            'live_tv_categories' => [
                'view' => 'admin.live.tv.categories',
                'add' => 'admin.live.tv.category.add',
                'store' => 'admin.live.tv.category.store',
                'delete' => 'admin.live.tv.category.delete',
                'edit' => 'admin.live.tv.category.edit',
                'update' => 'admin.live.tv.category.update',
                'status' => 'admin.live.tv.category.status',
            ],
            'live_tv' => [
                'view' => 'admin.live.tvs',
                'add' => 'admin.live.tv.add',
                'store' => 'admin.live.tv.store',
                'delete' => 'admin.live.tv.delete',
                'edit' => 'admin.live.tv.edit',
                'update' => 'admin.live.tv.update',
                'status' => 'admin.live.tv.status',
                'feature' => 'admin.live.tv.feature',
            ],
            'seasons' => [
                'view' => 'admin.seasons',
                'add' => 'admin.season.add',
                'store' => 'admin.season.store',
                'delete' => 'admin.season.delete',
                'edit' => 'admin.season.edit',
                'update' => 'admin.season.update',
            ],
            'episodes' => [
                'view' => 'admin.episodes',
                'add' => 'admin.episode.add',
                'store' => 'admin.episode.store',
                'delete' => 'admin.episode.delete',
                'edit' => 'admin.episode.edit',
                'update' => 'admin.episode.update',
            ],
            'stars' => [
                'view' => 'admin.stars',
                'add' => 'admin.star.add',
                'store' => 'admin.star.store',
                'delete' => 'admin.star.delete',
                'edit' => 'admin.star.edit',
                'update' => 'admin.star.update',
                'status' => 'admin.star.status',
            ],
            'movie_industries' => [
                'view' => 'admin.movie_industries',
                'add' => 'admin.movie_industry.add',
                'store' => 'admin.movie_industry.store',
                'delete' => 'admin.movie_industry.delete',
                'edit' => 'admin.movie_industry.edit',
                'update' => 'admin.movie_industry.update',
                'status' => 'admin.movie_industry.status',
            ],
            'movie_languages' => [
                'view' => 'admin.languages',
                'add' => 'admin.language.add',
                'store' => 'admin.language.store',
                'delete' => 'admin.language.delete',
                'edit' => 'admin.language.edit',
                'update' => 'admin.language.update',
                'status' => 'admin.language.status',
                'translations_page' => 'admin.language.translations.page',
                'translations_update' => 'admin.language.key.update',
            ],
            'countries' => [
                'view' => 'admin.countries',
                'add' => 'admin.country.add',
                'store' => 'admin.country.store',
                'delete' => 'admin.country.delete',
                'edit' => 'admin.country.edit',
                'update' => 'admin.country.update',
                'status' => 'admin.country.status',
            ],
            'staff' => [
                'view' => 'admin.staffs',
                'add' => 'admin.staff.add',
                'store' => 'admin.staff.store',
                'delete' => 'admin.staff.delete',
                'edit' => 'admin.staff.edit',
                'update' => 'admin.staff.update',
                'status' => 'admin.staff.status',
            ],
            'roles' => [
                'view' => 'roles.index',
                'create' => 'roles.create',
                'edit' => 'roles.edit',
                'update' => 'roles.update',
                'delete' => 'roles.destroy',
            ],
            'subscribers' => [
                'view' => 'admin.subscribers',
                'add' => 'admin.subscriber.add',
                'store' => 'admin.subscriber.store',
                'delete' => 'admin.subscriber.delete',
                'edit' => 'admin.subscriber.edit',
                'update' => 'admin.subscriber.update',
                'status' => 'admin.subscriber.status',
            ],
            'packages' => [
                'view' => 'admin.packages',
                'add' => 'admin.package.add',
                'store' => 'admin.package.store',
                'delete' => 'admin.package.delete',
                'edit' => 'admin.package.edit',
                'update' => 'admin.package.update',
                'status' => 'admin.package.status',
            ],
            'video_qualities' => [
                'view' => 'admin.video.qualities',
                'add' => 'admin.video.quality.add',
                'store' => 'admin.video.quality.store',
                'delete' => 'admin.video.quality.delete',
                'edit' => 'admin.video.quality.edit',
                'update' => 'admin.video.quality.update',
                'status' => 'admin.video.quality.status',
            ],
            'importer' => [
                'view' => 'admin.importer',
                'fetch_movies' => 'admin.fetch.movies',
                'import_db' => 'admin.import.db',
            ],
            'interest' => [
                'view' => 'admin.interest',
                'add' => 'admin.interest.add',
                'store' => 'admin.interest.store',
                'delete' => 'admin.interest.delete',
                'edit' => 'admin.interest.edit',
                'update' => 'admin.interest.update',
                'status' => 'admin.interest.status',
            ],
            'settings' => [
                'system' => 'admin.system.settings',
                'admin' => 'admin.settings',
                'tmdb' => 'admin.tmdb.settings',
                'social' => 'admin.social.settings',
                'recaptcha' => 'admin.recaptcha.settings',
                'update' => 'admin.setting.update',
                'status_change' => 'setting.status.change',
                'sms_gateway' => 'admin.sms-gateway-settings',
            ],
            'blog_categories' => [
                'view' => 'admin.blog.categories',
                'add' => 'admin.blog.category.add',
                'store' => 'admin.blog.category.store',
                'delete' => 'admin.blog.category.delete',
                'edit' => 'admin.blog.category.edit',
                'update' => 'admin.blog.category.update',
                'status' => 'admin.blog.category.status',
            ],
            'blogs' => [
                'view' => 'admin.blogs',
                'add' => 'admin.blog.add',
                'store' => 'admin.blog.store',
                'delete' => 'admin.blog.delete',
                'edit' => 'admin.blog.edit',
                'update' => 'admin.blog.update',
                'status' => 'admin.blog.status',
            ],
            'faqs' => [
                'view' => 'admin.faqs',
                'add' => 'admin.faq.add',
                'store' => 'admin.faq.store',
                'delete' => 'admin.faq.delete',
                'edit' => 'admin.faq.edit',
                'update' => 'admin.faq.update',
                'status' => 'admin.faq.status',
            ],
            'pages' => [
                'index' => 'pages.index',
                'create' => 'pages.create',
                'store' => 'pages.store',
                'edit' => 'pages.edit',
                'update' => 'pages.update',
                'delete' => 'page.delete',
                'status_change' => 'page.status.change',
            ],
            'ads' => [
                'index' => 'admin.ads',
                'delete' => 'admin.ads.delete',
                'edit' => 'admin.ads.edit',
                'update' => 'admin.ads.update',
                'status' => 'admin.ads.status',
                'pre_roll_index' => 'admin.ads.pre_roll.index',
                'pre_roll_add' => 'admin.ads.pre_roll.add',
                'pre_roll_edit' => 'admin.ads.pre_roll.edit',
                'pre_roll_update' => 'admin.ads.pre_roll.update',
                'pre_roll_store' => 'admin.ads.pre_roll.store',
                'mid_roll_index' => 'admin.ads.mid_roll.index',
                'mid_roll_add' => 'admin.ads.mid_roll.add',
                'mid_roll_edit' => 'admin.ads.mid_roll.edit',
                'mid_roll_update' => 'admin.ads.mid_roll.update',
                'mid_roll_store' => 'admin.ads.mid_roll.store',
                'post_roll_index' => 'admin.ads.post_roll.index',
                'post_roll_add' => 'admin.ads.post_roll.add',
                'post_roll_edit' => 'admin.ads.post_roll.edit',
                'post_roll_update' => 'admin.ads.post_roll.update',
                'post_roll_store' => 'admin.ads.post_roll.store',
            ],
            'profile' => [
                'manage_profile' => 'admin.manage.profile',
                'update_profile' => 'admin.update.profile',
                'change_password' => 'admin.change.password',
                'password_update' => 'admin.password.update',
            ],

            'subscription' => [
                'payment_gateway_view' => 'payment.gateways',
                'payment_gateway_save' => 'payment.gateway',
                'all_subscription' => 'all.subscription',
                'transaction_log' => 'transaction.log',
                'rental_history' => 'rental.history',
                'subscription_status' => 'subscribe-list.status',
                'add_subscription' => 'admin.add.subscription',
                'create_subscription' => 'create.subscription',
                'rent_status' => 'rent-list.status',
                'stop_recurring' => 'stop.recurring',
            ],

            'website_theme' => [
                'theme_options_view' => 'admin.theme.options',
                'theme_options_update' => 'admin.theme.options.post',
                'website_seo' => 'website.seo',
            ],

            'system' => [
                'server_info' => 'server.info',
                'system_info' => 'system.info',
                'extension_library' => 'extension.library',
                'file_system_permission' => 'file.system.permission',
                'system_update_view' => 'system.update',
                'system_update_post' => 'download.system.update',
            ],

            'footer' => [
                'footer_content' => 'footer.content',
                'primary_content_setting_view' => 'footer.primary-content',
                'primary_content_setting_save' => 'footer.primary-content',
                'payment_banner_setting' => 'footer.payment-banner-settings',
                'copyright_setting' => 'footer.copyright',
                'update_footer_setting' => 'footer.update-setting',
                'update_footer_menu' => 'footer.update-menu',
                'social_link' => 'footer.social-link',
                'app_links' => 'footer.app_links',
                'legal_pages_link_setting' => 'footer.legal_pages_link_setting',
                'help_center_link_setting' => 'footer.help_center_link_setting',
            ],

            'movie_requests' => [
                'index' => 'admin.movie_requests',
                'delete' => 'admin.movie_request.delete',
                'update' => 'admin.movie_request.update',
            ],

            'reports' => [
                'index' => 'admin.reports',
                'delete' => 'admin.report.delete',
                'update' => 'admin.report.update',
            ],
            'system_languages' => [
                'view' => 'admin.system.languages',
                'add' => 'admin.system.language.add',
                'store' => 'admin.system.language.store',
                'edit' => 'admin.system.language.edit',
                'update' => 'admin.system.language.update',
                'delete' => 'admin.system.language.destroy',
                'translations_page' => 'admin.language.translations.page',
                'translations_update' => 'admin.language.key.update',
                'translations_delete' => 'admin.language.translations.delete',
                'missing_keys' => 'admin.language.missing-keys',
                'scan_and_store' => 'admin.language.scan',
                'status_change' => 'system-language-status',
            ],
            'genres' => [
                'view' => 'admin.genres',
                'add' => 'admin.genre.add',
                'store' => 'admin.genre.store',
                'delete' => 'admin.genre.delete',
                'edit' => 'admin.genre.edit',
                'update' => 'admin.genre.update',
                'status' => 'admin.genre.status',
                'featured' => 'admin.genre.featured',
            ],
            'reviews' => [
                'view' => 'admin.reviews',
                'details' => 'admin.review.details',
                'reply_view' => 'admin.review.reply.view',
                'reply' => 'admin.review.reply',
                'delete' => 'admin.review.delete',
            ],
            'customer_queries' => [
                'view' => 'admin.customer_queries.index',
                'delete' => 'admin.customer_queries.delete',
                'reply_view' => 'admin.customer_queries.reply.view',
                'reply' => 'admin.customer_queries.reply',
            ],

        ];

        $admin_permission = [];

        Permission::truncate();

        foreach ($attributes as $group => $permissions) {
            $permission = new Permission;
            $permission->name = str_replace('_', ' ', $group);
            $permission->attribute = $group;
            $permission->keywords = $permissions;
            $permission->save();

            foreach ($permissions as $key => $route) {
                $admin_permission[] = trim($route);
            }
        }

        if ($user = \App\Models\User::first()) {
            $user->permissions = $admin_permission;
            $user->save();
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('permissions');
    }
};
