<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('company_name');
            $table->text('logo')->nullable();
            $table->string('slug');
            $table->bigInteger('country_id')->unsigned()->nullable();
            $table->text('address')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('payment_details')->nullable();
            $table->string('stripe_customer_id')->nullable();
            $table->string('paddle_customer_id')->nullable();
            $table->string('webhook_verify_token', 100)->index()->unique()->nullable()->comment('Generated By System: for webhook request verification');
            $table->string('api_key', 100)->index()->unique()->nullable()->comment('Generated By System: for API request verification');
            $table->string('default_ai')->nullable();
            $table->string('openai_api_key')->nullable();
            $table->string('deepseek_api_key')->nullable();
            $table->string('default_language')->nullable();
            $table->integer('default_length')->nullable();
            $table->string('default_tone')->nullable();
            $table->string('default_level')->nullable();
            $table->tinyInteger('status')->default(1)->comment('0 inactive, 1 active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
