<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');

            $table->morphs('reportable');

            $table->enum('video_issue', ['broken', 'wrong_movie', 'others'])->nullable();
            $table->enum('audio_issue', ['not_synced', 'wrong_audio', 'others'])->nullable();
            $table->enum('subtitle_issue', ['not_synced', 'wrong_subtitle', 'others'])->nullable();

            $table->text('message')->nullable();

            $table->enum('status', ['pending', 'resolved'])->default('pending');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reports');
    }
};
