<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rental_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('video_id');
            $table->string('video_type')->comment('1: Movie, 2: TV Show, 3: Live TV'); // Type of video
            $table->string('type')->nullable(); // Type of video
            $table->text('file')->nullable(); // Type of video
            $table->integer('status')->nullable()->default(0); // Type of video
            $table->string('transaction_id')->nullable(); // Transaction ID from payment history
            $table->float('price')->nullable(); // Price of the rent
            $table->integer('duration')->nullable()->comment('in hours'); // Duration in hours
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rental_histories');
    }
};
