<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('watch_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->morphs('watchable'); // For polymorphic relationship
            $table->integer('duration')->default(0); // Total video duration in seconds
            $table->integer('watched_seconds')->default(0); // Total seconds watched
            $table->integer('watch_count')->default(1); // How many times watched
            $table->float('completion_percentage')->default(0);
            $table->timestamp('last_watched_at')->nullable();
            $table->timestamps();

            $table->unique(['user_id', 'watchable_id', 'watchable_type']);

            // $table->id();
            // $table->integer('user_id');
            // $table->integer('movie_id')->nullable();
            // $table->integer('tv_show_id')->nullable();
            // $table->integer('episode_id')->nullable();
            // $table->integer('progress')->default(0); // in seconds or percentage
            // $table->timestamp('last_watched_at')->nullable();
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('watch_histories');
    }
};
