<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->string('title', 191);
            $table->string('type', 20);
            $table->string('position', 50)->nullable();
            $table->integer('status')->default(1);
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->string('redirect_url', 191)->nullable();
            $table->string('size', 20)->nullable();
            $table->text('banner')->nullable();
            $table->text('content')->nullable();
            $table->text('video_link')->nullable();
            $table->integer('total_views')->nullable()->default(0); // allowed views
            $table->integer('views_count')->nullable()->default(0); // actual views
            $table->integer('ad_duration')->nullable(); // in seconds
            $table->integer('skip_after')->nullable(); // in seconds
            $table->integer('frequency_capping')->nullable(); // max views per user per day
            $table->string('start_time')->nullable(); 
            $table->string('end_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads');
    }
};
