<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('live_tv_urls', function (Blueprint $table) {
            $table->id();
            $table->string('stream_key',50)->nullable();
            $table->integer('live_tv_id')->nullable();
            $table->string('url_for',191)->nullable();
            $table->string('source',191)->nullable();
            $table->string('label',191)->nullable();
            $table->string('quality',191)->nullable();
            $table->mediumText('url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('live_tv_urls');
    }
};
