<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('episodes', function (Blueprint $table) {
            $table->id();
            $table->integer('season_id')->nullable();
            $table->integer('series_id')->nullable();
            $table->string('episode_name')->nullable();
            $table->string('slug')->nullable();
            $table->longText('description')->nullable();
            $table->string('file_source')->nullable();
            $table->string('source_type')->nullable();
            $table->string('file_url')->nullable();
            $table->integer('order')->default(0);
            $table->integer('runtime')->default(0);
            $table->longText('poster')->nullable();
            $table->integer('total_view')->nullable()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('episodes');
    }
};
