<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique();
            $table->string('password');
            $table->string('username', 191)->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('phone')->nullable();
            $table->text('image')->nullable();
            $table->string('date_of_birth')->nullable();
            $table->enum('user_type', ['admin', 'user', 'staff'])->default('user');
            $table->tinyInteger('gender')->nullable()->default(1)->comment('1 Male, 2 Female, Rather not say 0');
            $table->mediumText('token')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->string('theme', 50)->nullable()->default('default');
            $table->string('theme_color', 50)->nullable()->default('#16163F');
            $table->dateTime('join_date')->nullable();
            $table->mediumText('deactivate_reason')->nullable();
            $table->string('firebase_auth_uid', 191)->nullable();
            $table->text('permissions')->nullable();
            $table->text('interests')->nullable();
            $table->timestamp('last_login')->nullable();
            $table->tinyInteger('is_user_banned')->default(0)->comment('0 unban, 1 ban');
            $table->tinyInteger('is_password_set')->default(1)->comment('0 for social login');
            $table->longText('socials')->nullable()->comment('it will be array data');
            $table->tinyInteger('status')->default(1)->comment('0 inactive, 1 active');
            $table->integer('role_id')->unsigned()->nullable();
            $table->integer('client_id')->unsigned()->nullable();
            $table->integer('subscription_id')->unsigned()->nullable();
            $table->string('remember_token')->nullable();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });

        // Uncomment the following lines to create a super admin user
        User::create([
            'first_name' => 'Super',
            'last_name' => 'Admin',
            'email' => 'admin@spagreen.net',
            'permissions' => '',
            'role_id' => 1,
            'password' => bcrypt(12345678),
            'phone' => '01726184147',
            'user_type' => 'admin'
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
