<?php

use App\Http\Middleware\AdminMiddleware;
use App\Http\Middleware\ApiMiddleware;
use App\Http\Middleware\InstallMiddleware;
use App\Http\Middleware\NotInstallCheckMiddleware;
use App\Http\Middleware\XssMiddleware;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful;


return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: [
            __DIR__.'/../routes/web.php',
            __DIR__.'/../routes/admin.php',
            __DIR__.'/../routes/user.php',
            __DIR__.'/../routes/install.php',
        ],
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'admin' => AdminMiddleware::class,
            'xss' => XssMiddleware::class,
            'NotInstalledCheck' => NotInstallCheckMiddleware::class,
            'isInstalled' => InstallMiddleware::class,
            'auth:sanctum' => EnsureFrontendRequestsAreStateful::class,
            'mobileApi' => ApiMiddleware::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
