<?php
namespace App\Repositories\Auth;

use App\Models\User;
use App\Models\Client;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Repositories\Interfaces\Auth\SocialAuthRepositoryInterface;
use Exception;
use Illuminate\Support\Facades\Log;

class SocialAuthRepository implements SocialAuthRepositoryInterface
{
   public function findOrCreateUserFromSocialite($user)
  {
     	$auth_id = $user->getId();
     	$slug = 'flix-00'.time();
     
     	$user = User::where('auth_id', $auth_id)->first();

        $client = Client::where('id', $user->client_id)->first();

        if(!$client) {
            $data = [
                'slug' => $slug,
                'first_name' => $user->getName() ?? $user->getNickname(),
                'last_name' => '',
                'company_name' => 'flixoo',
                'webhook_verify_token' => Str::random(30),
                'api_key' => Str::random(30),
            ];
            Client::insert($data);
        }

      return User::firstOrCreate(
          ['auth_id' => $user->getId()],
          [
              'first_name' => $user->getName() ?? $user->getNickname(),
              'last_name' => '',
                'email' => $user->getEmail(),
              'username' => $user->getNickname() ?? '',
              'image' => json_encode(['original_image' => $user->getAvatar() ?? '']),
              'status' => 1,
              'user_type' => 'user',
              'client_id' => Client::where('slug', $slug)->value('id'), // assign the client id here
              'password' => Hash::make(Str::random(16)),
          ]
      );
  }

}