<?php

namespace App\Repositories\Admin;

use App\Models\User;
use App\Models\VideoQuality;
use App\Repositories\Interfaces\Admin\VideoQualityInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Http\UploadedFile;

class VideoQualityRepository implements VideoQualityInterface
{
    use ImageTrait;

    public function all()
    {
        return VideoQuality::get();
    }

    public function store($request) {
        try {

            $data = [
                'quality' => $request['quality'],
                'description' => $request['description'],
                'status' => $request['status'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return VideoQuality::create($data);
           
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'quality' => $request['quality'],
                'description' => $request['description'],
                'status' => $request['status'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return VideoQuality::where('id', $id)->update($data);
           
        } catch (\Exception $e) {
            return false;
        }
    }
}
