<?php

namespace App\Repositories\Admin;

use App\Models\Config;
use App\Models\Movie;
use App\Models\TvShow;
use App\Repositories\Interfaces\Admin\TvShowInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Http\UploadedFile;

class TvShowRepository implements TvShowInterface
{
    use ImageTrait;

    public function all()
    {
        return Movie::get();
    }

    public function store($request)
    {
        try {
            if (isset($request['thumbnail']) && $request['thumbnail'] instanceof UploadedFile) {
                $requestImage = $request['thumbnail'];
                $response = $this->saveImage($requestImage, '_tv_show_');
                $thumbnail = $response['images'];
            }

            if (isset($request['poster']) && $request['poster'] instanceof UploadedFile) {
                $requestImage = $request['poster'];
                $response = $this->saveImage($requestImage, '_tv_show_');
                $poster = $response['images'];
            }
            $data = [
                'title' => $request['title'],
                'slug' => $request['slug'],
                'seo_title' => $request['seo_title'],
                'description' => $request['description'],
                'stars' => json_encode($request['actor']),
                'director' => json_encode($request['director']),
                'writer' => json_encode($request['writer']),
                'rating' => $request['imdb_rating'],
                'release' => $request['release_date'],
                'country' => json_encode($request['country']),
                'genre' => json_encode($request['genre']),
                'language' => json_encode($request['language']),
                'video_type' => $request['video_type'],
                'runtime' => $request['runtime'],
                'video_quality' => $request['video_quality'],
                'is_free' => 0,
                'is_featured' => $request['is_featured'],
                'is_original' => $request['is_original'],
                'is_popular' => $request['is_popular'],
                'is_blockbuster' => $request['is_blockbuster'],
                'is_recommended' => $request['is_recommended'],
                'is_real_life_story' => $request['is_real_life_story'],
                'status' => $request['status'],
                'trailer' => $request['trailer_youtube_source'] ? 1 : 0,
                'trailler_youtube_source' => $request['trailer_youtube_source'],
                'enable_download' => $request['enable_download'],
                'focus_keyword' => $request['focus_keyword'],
                'meta_description' => $request['meta_description'],
                'tags' => $request['tags'],
                'imdb_rating' => $request['imdb_rating'],
                'total_rating' => 0,
                'today_view' => 0,
                'weekly_view' => 0,
                'monthly_view' => 0,
                'total_view' => 0,
                'last_ep_added' => Carbon::now(),
                'imdbid' => 0,
                'tmdb_id' => 0,
                'thumbnail' => isset($thumbnail) ? json_encode($thumbnail) : '',
                'poster' => isset($poster) ? json_encode($poster) : '',
                
                'is_free' => (int)$request['is_free'],
                'is_rental' => (int)$request['is_rental'],
                
                'rental_price'      => isset($request['rental_price']) ? (int)$request['rental_price'] : null,
                'rental_duration'   => isset($request['rental_duration']) ? (int)$request['rental_duration'] : null,
                'rental_type'   => isset($request['rental_type']) ? $request['rental_type'] : null,

                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return TvShow::create($data);
        } catch (\Exception $e) {
            throw $e;
        }
    }

    public function update($request, $id)
    {
        try {
            $movie = TvShow::where('id', $id)->first();

            if (isset($request['thumbnail']) && $request['thumbnail'] instanceof UploadedFile) {
                $requestImage = $request['thumbnail'];
                $response = $this->saveImage($requestImage, '_tv_show_');
                $request['thumbnail'] = $response['images'];
            }

            if (isset($request['poster']) && $request['poster'] instanceof UploadedFile) {
                $requestImage = $request['poster'];
                $response = $this->saveImage($requestImage, '_tv_show_');
                $request['poster'] = $response['images'];
            }

            $data = [
                'title' => $request['title'],
                'slug' => $request['slug'],
                'seo_title' => $request['seo_title'],
                'description' => $request['description'],
                'stars' => $request['actor'],
                'director' => $request['director'],
                'writer' => $request['writer'],
                'rating' => $request['imdb_rating'],
                'release' => $request['release_date'],
                'country' => json_encode($request['country']),
                'genre' => json_encode($request['genre']),
                'language' => json_encode($request['language']),
                'video_type' => $request['video_type'],
                'runtime' => $request['runtime'],
                'video_quality' => $request['video_quality'],
                'is_free' => 0,
                'is_original' => $request['is_original'],
                'is_featured' => $request['is_featured'],
                'is_popular' => $request['is_popular'],
                'is_blockbuster' => $request['is_blockbuster'],
                'is_recommended' => $request['is_recommended'],
                'is_real_life_story' => $request['is_real_life_story'],
                'status' => $request['status'],
                'trailer' => $request['trailer_youtube_source'] ? 1 : 0,
                'trailler_youtube_source' => $request['trailer_youtube_source'],
                'enable_download' => $request['enable_download'],
                'focus_keyword' => $request['focus_keyword'],
                'meta_description' => $request['meta_description'],
                'tags' => $request['tags'],
                'imdb_rating' => $request['imdb_rating'],
                'total_rating' => 0,
                'today_view' => 0,
                'weekly_view' => 0,
                'monthly_view' => 0,
                'total_view' => 0,
                'last_ep_added' => Carbon::now(),
                'imdbid' => 0,
                'tmdb_id' => 0,
                'thumbnail' => isset($request['thumbnail']) ? json_encode($request['thumbnail']) : $movie->thumbnail,
                'poster' => isset($request['poster']) ? json_encode($request['poster']) : $movie->poster,

                'is_free'    => (int)$request['is_free'],
                'is_rental'  => (int)$request['is_rental'],
                'rental_price'      => $request['is_rental'] ? (int)$request['rental_price'] : null,
                'rental_duration'   => $request['is_rental'] ? (int)$request['rental_duration'] : null,
                'rental_type'   => $request['is_rental'] ? $request['rental_type'] : null,

                'updated_at' => Carbon::now(),
            ];
            return TvShow::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function config($request)
    {
        try {
            $timestamp = Carbon::now(); // Get current timestamp
            foreach ($request as $key => $value) {
                if ($key == '_token') {
                    continue;
                }
                Config::updateOrCreate(
                    ['title' => $key],
                    [
                        'value' => $value,
                        'updated_at' => $timestamp,
                        'created_at' => Config::where('title', $key)->exists() ? Config::where('title', $key)->value('created_at') : $timestamp
                    ]
                );
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }
}
