<?php

namespace App\Repositories\Admin;

use App\Models\ApiKey;
use App\Models\Config;
use App\Models\Package;
use App\Models\Season;
use App\Models\Star;
use App\Repositories\Interfaces\Admin\SettingInterface;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use App\Traits\ImageTrait;

class SettingRepository implements SettingInterface
{

    use ImageTrait;
    public function all()
    {
        return Season::get();
    }

    public function update($request): bool
    {
        $site_lang = $request->site_lang ?? 'en';

        foreach ($request->except('_token', 'payment_method', 'is_modal', '_method', 'site_lang', 'mobile_app', 'chat_messenger', 'countries', 'r') as $key => $value) {
            if ($key == 'default_language') {
                $setting = Config::where('title', $key)->first();
            } else {
                if (isset($site_lang) && in_array($key, get_yrsetting('setting_by_lang'))) {
                    $setting = Config::where('title', $key)->first();
                } else {
                    $setting = Config::where('title', $key)->first();
                }
            }



            if (in_array($key, get_yrsetting('setting_array'))) {
                $value = serialize($value);
            }

            if (blank($setting)) {
                $setting        = new Config();
                $setting->title = $key;

                $setting->value = $value;
            } else {

                $setting->value = $value;
            }

            $setting->save();
        }
        Cache::flush();
        return true;
    }

    public function systemStatus($request)
    {
        if ($request->has('data.name') && $request->has('data.value')) {
            $title = $request->input('data.name');
            $value = $request->input('data.value');

            Config::updateOrCreate(
                ['title' => $title],
                ['value' => $value]
            );

            return [
                'status'    => 'success',
                'message'   => __('setting_updated_successfully'),
                'title'     => __('success'),
                'is_reload' => true,
            ];
        }

        return [
            'status'    => 'error',
            'message'   => __('setting_updated_failled'),
            'title'     => __('error'),
            'is_reload' => true,
        ];
    }

    public function apiKeyStore($request)
    {
        try {
            $data = [
                'title' => $request->title,
                'key' => $request->api_key,
                'status' => 1,
                'user_id' => auth()->user()->id,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return ApiKey::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }
    public function apiKeyUpdate($request, $id)
    {
        try {
            $data = [
                'title' => $request->title,
                'key' => $request->api_key,
                'updated_at' => Carbon::now(),
            ];
            return ApiKey::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}
