<?php

namespace App\Repositories\Admin;

use App\Models\Package;
use App\Models\Season;
use App\Models\Star;
use App\Repositories\Interfaces\Admin\PackageInterface;
use App\Repositories\Interfaces\Admin\SeasonInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Support\Str;
use Illuminate\Http\UploadedFile;

class SeasonRepository implements SeasonInterface
{
    use ImageTrait;

    public function all()
    {
        return Season::get();
    }

    public function store($request) {
        try {
            $data = [
                'season_name' => $request['season_name'],
                'order' => $request['order'],
                'slug' => slugify($request['season_name']),
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Season::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'season_name' => $request['season_name'],
                'slug' => slugify($request['season_name']),
                'order' => $request['order'],
                'updated_at' => Carbon::now(),
            ];
            return Season::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}