<?php
namespace App\Repositories\Admin;

use App\Models\MovieRequest;
use App\Repositories\Interfaces\Admin\MovieRequestInterface;

class MovieRequestRepository implements MovieRequestInterface
{
    public function all()
    {
        return MovieRequest::latest()->get();
    }

    public function find($id)
    {
        return MovieRequest::findOrFail($id);
    }

    public function create(array $data)
    {
        return MovieRequest::create($data);
    }

    public function update($id, array $data)
    {
        $movieRequest = $this->find($id);
        $movieRequest->update($data);
        return $movieRequest;
    }

    public function delete($id)
    {
        return MovieRequest::destroy($id);
    }
}