<?php

namespace App\Repositories\Admin;

use App\Models\Category;
use App\Models\Country;
use App\Repositories\Interfaces\Admin\CountryInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class CountryRepository implements CountryInterface
{
    use ImageTrait;

    public function all()
    {
        return Category::get();
    }

    public function store($request) {
        try {
            if (isset($request['country_flag']) && $request['country_flag'] instanceof UploadedFile) {
                $requestImage = $request['country_flag'];
                $response = $this->saveImage($requestImage, '_country_');
                $request['country_flag'] = $response['images'];
            }
            $data = [
                'name' => $request['name'],
                'slug' => Str::slug($request['name']),
                'description' => $request['description'],
                'status' => $request['status'],
                'flag' => isset($request['country_flag']) ? json_encode($request['country_flag']) : '',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Country::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'name' => $request['name'],
                'slug' => Str::slug($request['name']),
                'description' => $request['description'],
                'status' => $request['status'],
                'updated_at' => Carbon::now(),
            ];
            return Country::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}