<?php

namespace App\Repositories\Admin;

use App\Models\BlogCategory;
use App\Repositories\Interfaces\Admin\BlogCategoryInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;

class BlogCategoryRepository implements BlogCategoryInterface
{
    use ImageTrait;

    public function all()
    {
        return BlogCategory::get();
    }

    public function store($request)
    {
        try {
            $data = [
                'title' => $request['title'],
                'status' => $request['status'] ?? 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return BlogCategory::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id)
    {
        try {
            $data = [
                'title' => $request['title'],
                'status' => $request['status'] ?? 0,
                'updated_at' => Carbon::now(),
            ];
            return BlogCategory::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}