<?php

namespace App\Repositories\Admin;

use App\Models\Ads;
use App\Models\Faq;
use App\Repositories\Interfaces\Admin\AdsInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Log;

class AdsRepository implements AdsInterface
{
    use ImageTrait;

    public function all()
    {
        return Ads::get();
    }

    public function store($request, $type = null) {
        try {
            $banner = null;
            // Handle file upload
            if (isset($request['banner']) && $request['banner'] instanceof UploadedFile) {
                $requestImage = $request['banner'];
                $response = $this->saveImage($requestImage, '_ads_');
                $banner = $response['images'];
            }

            $data = [
                'title' => $request['title'],
                // 'position' => $request['position'] ?? null,
                'type' => $request['type'],
                'content' => $request['content'] ?? null,
                'status' => $request['status'],
                'start_date' => $request['start_date'] ?? null,
                'end_date' => $request['end_date'] ?? null,
                'redirect_url' => isset($request['redirect_url']) ? $request['redirect_url'] : null,
                'video_link' => $banner ? null : ($request['video_link'] ?? null), // Only store link if no file
                'banner' => $banner ? json_encode($banner) : null,
                'total_views' => $request['total_views'] ?? 0,
                'ad_duration' => $request['ad_duration'] ?? null,
                'skip_after' => $request['skip_after'] ?? null,
                'frequency_capping' => $request['frequency_capping'] ?? null,
                'size' => $request['size'] ?? null,
                'views_count' => 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];

            if ($type == 'mid_roll') {
                $data['start_time'] = $request['start_time']; // Override type if provided
                $data['end_time'] = $request['end_time']; // Override type if provided
            }

            return Ads::create($data);
        } catch (\Exception $e) {
            Log::error('Ad Store Error: ' . $e->getMessage());
            return false;
        }
    }

    public function update($request, $id, $type = null) {
        try {
            $banner = null;
            if (isset($request['banner']) && $request['banner'] instanceof UploadedFile) {
                $requestImage = $request['banner'];
                $this->imageDelete($id, 'ads', 'banner');
                $response = $this->saveImage($requestImage, '_ads_');
                $banner = $response['images'];
            }
            $data = [
                'title' => $request['title'],
                // 'position' => $request['position'] ?? null,
                'type' => $request['type'],
                'content' => $request['content'] ?? null,
                'status' => $request['status'],
                'start_date' => $request['start_date'] ?? null,
                'end_date' => $request['end_date'] ?? null,
                'redirect_url' => isset($request['redirect_url']) ? $request['redirect_url'] : null,
                'video_link' => $banner ? null : ($request['video_link'] ?? null), // Only store link if no file
                'total_views' => $request['total_views'] ?? 0,
                'ad_duration' => $request['ad_duration'] ?? null,
                'skip_after' => $request['skip_after'] ?? null,
                'frequency_capping' => $request['frequency_capping'] ?? null,
                'size' => $request['size'] ?? null,
                'views_count' => 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];

            if ($type == 'mid_roll') {
                $data['start_time'] = $request['start_time']; // Override type if provided
                $data['end_time'] = $request['end_time']; // Override type if provided
            }

            if($banner) {
                $data['banner'] = json_encode($banner);
            }
            return Ads::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}