<?php

namespace App\Providers;

use App\Repositories\Admin\BlogCategoryRepository;
use App\Repositories\Admin\BlogRepositories;
use App\Repositories\Admin\CategoryRepository;
use App\Repositories\Admin\ConfigRepository;
use App\Repositories\Admin\CountryRepository;
use App\Repositories\Admin\CustomerQueryRepository;
use App\Repositories\Admin\DownloadLinkRepository;
use App\Repositories\Admin\EpisodeRepository;
use App\Repositories\Admin\FaqRepository;
use App\Repositories\Admin\GenreRepository;
use App\Repositories\Admin\AdsRepository;
use App\Repositories\Admin\ImporterRepository;
use App\Repositories\Admin\InterestRepository;
use App\Repositories\Admin\LanguageRepository;
use App\Repositories\Admin\LiveTvCategoryRepository;
use App\Repositories\Admin\LiveTvRepository;
use App\Repositories\Admin\MovieIndustryRepository;
use App\Repositories\Admin\MovieRepository;
use App\Repositories\Admin\MovieRequestRepository;
use App\Repositories\Admin\PackageRepository;
use App\Repositories\Admin\PermissionRepository;
use App\Repositories\Admin\ReportRepository;
use App\Repositories\Admin\ReviewRepository;
use App\Repositories\Admin\RoleRepository;
use App\Repositories\Admin\SeasonRepository;
use App\Repositories\Admin\StaffRepository;
use App\Repositories\Admin\StarRepository;
use App\Repositories\Admin\SubscriberRepository;
use App\Repositories\Admin\TvShowRepository;
use App\Repositories\Admin\VideoQualityRepository;
use App\Repositories\Interfaces\Admin\BlogCategoryInterface;
use App\Repositories\Interfaces\Admin\BlogInterface;
use App\Repositories\Interfaces\Admin\CategoryInterface;
use App\Repositories\Interfaces\Admin\ConfigInterface;
use App\Repositories\Interfaces\Admin\CountryInterface;
use App\Repositories\Interfaces\Admin\CustomerQueryInterface;
use App\Repositories\Interfaces\Admin\DownloadLinkInterface;
use App\Repositories\Interfaces\Admin\EpisodeInterface;
use App\Repositories\Interfaces\Admin\FaqInterface;
use App\Repositories\Interfaces\Admin\GenreInterface;
use App\Repositories\Interfaces\Admin\ImporterInterface;
use App\Repositories\Interfaces\Admin\InterestInterface;
use App\Repositories\Interfaces\Admin\LanguageInterface;
use App\Repositories\Interfaces\Admin\LiveTvCategoryInterface;
use App\Repositories\Interfaces\Admin\LiveTvInterface;
use App\Repositories\Interfaces\Admin\MovieIndustryInterface;
use App\Repositories\Interfaces\Admin\MovieInterface;
use App\Repositories\Interfaces\Admin\MovieRequestInterface;
use App\Repositories\Interfaces\Admin\PackageInterface;
use App\Repositories\Interfaces\Admin\PageRepositoryInterface;
use App\Repositories\Interfaces\Admin\PermissionInterface;
use App\Repositories\Interfaces\Admin\ReportInterface;
use App\Repositories\Interfaces\Admin\ReviewInterface;
use App\Repositories\Interfaces\Admin\RoleInterface;
use App\Repositories\Interfaces\Admin\SeasonInterface;
use App\Repositories\Interfaces\Admin\StaffInterface;
use App\Repositories\Interfaces\Admin\StarInterface;
use App\Repositories\Interfaces\Admin\SubscriberInterface;
use App\Repositories\Interfaces\Admin\TvShowInterface;
use App\Repositories\Interfaces\Admin\VideoQualityInterface;
use App\Repositories\Interfaces\Website\FavoriteRepositoryInterface;
use App\Repositories\Interfaces\Website\PlayListRepositoryInterface;
use App\Repositories\Interfaces\Auth\SocialAuthRepositoryInterface;
use App\Repositories\Admin\PageRepository;
use App\Repositories\Admin\SettingRepository;
use App\Repositories\Website\FavoriteRepository;
use App\Repositories\Website\PlayListRepository;
use App\Repositories\Auth\SocialAuthRepository;
use App\Repositories\Interfaces\Admin\AdsInterface;
use App\Repositories\Interfaces\Admin\SettingInterface;
use App\Repositories\Interfaces\Website\BlogRepositoryInterface;
use App\Repositories\Interfaces\Website\HomeRepositoryInterface;
use App\Repositories\Interfaces\Website\PlayerRepositoryInterface;
use App\Repositories\Interfaces\Website\SubscriptionRepositoryInterface;
use App\Repositories\Website\BlogRepository;
use App\Repositories\Website\HomeRepository;
use App\Repositories\Website\PlayerRepository;
use App\Repositories\Website\SubscriptionRepository;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register()
    {
        // Bind the interface to the repository
        $this->app->bind(MovieInterface::class, MovieRepository::class);
        $this->app->bind(CategoryInterface::class, CategoryRepository::class);
        $this->app->bind(StarInterface::class, StarRepository::class);
        $this->app->bind(LanguageInterface::class, LanguageRepository::class);
        $this->app->bind(CountryInterface::class, CountryRepository::class);
        $this->app->bind(GenreInterface::class, GenreRepository::class);
        $this->app->bind(StaffInterface::class, StaffRepository::class);
        $this->app->bind(SubscriberInterface::class, SubscriberRepository::class);
        $this->app->bind(PackageInterface::class, PackageRepository::class);
        $this->app->bind(VideoQualityInterface::class, VideoQualityRepository::class);
        $this->app->bind(TvShowInterface::class, TvShowRepository::class);
        $this->app->bind(ImporterInterface::class, ImporterRepository::class);
        $this->app->bind(SeasonInterface::class, SeasonRepository::class);
        $this->app->bind(LiveTvCategoryInterface::class, LiveTvCategoryRepository::class);
        $this->app->bind(LiveTvInterface::class, LiveTvRepository::class);
        $this->app->bind(BlogCategoryInterface::class, BlogCategoryRepository::class);
        $this->app->bind(BlogInterface::class, BlogRepositories::class);
        $this->app->bind(InterestInterface::class, InterestRepository::class);
        $this->app->bind(FaqInterface::class, FaqRepository::class);
        $this->app->bind(PlayListRepositoryInterface::class, PlayListRepository::class);
        $this->app->bind(FavoriteRepositoryInterface::class, FavoriteRepository::class);
        $this->app->bind(SocialAuthRepositoryInterface::class, SocialAuthRepository::class);
        $this->app->bind(MovieIndustryInterface::class, MovieIndustryRepository::class);
        $this->app->bind(CustomerQueryInterface::class, CustomerQueryRepository::class);
        $this->app->bind(ReviewInterface::class, ReviewRepository::class);
        $this->app->bind(DownloadLinkInterface::class, DownloadLinkRepository::class);
        $this->app->bind(AdsInterface::class, AdsRepository::class);
        $this->app->bind(MovieRequestInterface::class, MovieRequestRepository::class);
        $this->app->bind(ReportInterface::class, ReportRepository::class);
        $this->app->bind(ConfigInterface::class, ConfigRepository::class);
        $this->app->bind(HomeRepositoryInterface::class, HomeRepository::class);
        $this->app->bind(BlogRepositoryInterface::class, BlogRepository::class);
        $this->app->bind(PlayerRepositoryInterface::class, PlayerRepository::class);
        $this->app->bind(PageRepositoryInterface::class, PageRepository::class);
        $this->app->bind(SettingInterface::class, SettingRepository::class);
        $this->app->bind(SubscriptionRepositoryInterface::class, SubscriptionRepository::class);
        $this->app->bind(RoleInterface::class, RoleRepository::class);
        $this->app->bind(PermissionInterface::class, PermissionRepository::class);
        $this->app->bind(EpisodeInterface::class, EpisodeRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);

        if ($this->app->runningInConsole()) {
            return;
        }

        try {
            DB::connection()->getPdo();
        } catch (\Exception $e) {
            // Only redirect if we are NOT already on installer route
            if (!request()->is('install*')) {
                $installUrl = url('install/initialize');
                redirect($installUrl)->send();
                exit;
            }
        }
    }
}
