<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class User extends Authenticatable
{
    use HasFactory, HasApiTokens, Notifiable;

    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'password',
        'user_type',
        'phone',
        'role_id',
        'gender',
        'status',
        'image',
        'token',
        'expires_at',
        'client_id',
        'permissions',
        'auth_id'

    ];

    protected $casts = [
        'permissions' => 'array'
    ];
  
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    public function paymentHistories()
    {
        return $this->hasMany(Subscription::class, 'client_id', 'client_id');
    }
    public function playLists()
    {
        return $this->hasMany(PlayList::class);
    }
    public function favoriteMovies()
    {
        return $this->belongsToMany(Movie::class, 'favorite_movies');
    }

    public function favoriteTvShows()
    {
        return $this->belongsToMany(TvShow::class, 'favorite_tv_shows');
    }

    public function favoriteLiveTvs()
    {
        return $this->belongsToMany(LiveTv::class, 'favorite_live_tvs');
    }
    public function reviews()
    {
        return $this->hasMany(Review::class);
    }
    public function hasReviewed(Model $reviewable): bool
    {
        return $this->reviews()
            ->where('reviewable_id', $reviewable->id)
            ->where('reviewable_type', get_class($reviewable))
            ->exists();
    }
}
