<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Season extends Model
{
    protected $fillable = [
        'season_name',
        'order',
        'tv_show_id',
        'slug'
    ];
    public function episodes()
    {
        return $this->hasMany(Episode::class, 'season_id', 'id');
    }
    // In Season
    public function tvShows()
    {
        return $this->belongsToMany(TvShow::class);
    }
}
