<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RentalHistory extends Model
{
    protected $fillable = [
        'duration',
        'price',
        'transaction_id',
        'video_type',
        'video_id',
        'user_id',
        'type',
        'status',
        'file'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function movie()
    {
        return $this->belongsTo(Movie::class, 'video_id');
    }
    public function series()
    {
        return $this->belongsTo(TvShow::class, 'video_id');
    }
}
