<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PlayListMovie extends Model
{
    protected $fillable = [
        'play_list_id',
        'movie_id',
    ];

    public function playlist()
    {
        return $this->belongsTo(PlayList::class, 'play_list_id');
    }

    public function movie()
    {
        return $this->belongsTo(Movie::class);
    }
}
