<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaymentHistory extends Model
{
    protected $fillable = [
        'user_id',
        'package_id',
        'payment_gateway',
        'transaction_id',
        'amount',
        'currency',
        'status',
        'details',
        'payment_type',
        'video_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }
}
