<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Movie extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'seo_title',
        'description',
        'stars',
        'director',
        'writer',
        'rating',
        'release',
        'country',
        'genre',
        'is_featured',
        'is_recommended',
        'is_trending',
        'language',
        'video_type',
        'runtime',
        'video_quality',
        'is_free',
        'is_original',
        'is_blockbuster',
        'is_real_life_story',
        'status',
        'trailer',
        'trailler_youtube_source',
        'enable_download',
        'focus_keyword',
        'meta_description',
        'tags',
        'imdb_rating',
        'is_tvseries',
        'total_rating',
        'today_view',
        'weekly_view',
        'monthly_view',
        'total_view',
        'last_ep_added',
        'imdbid',
        'thumbnail',
        'poster',
        'tmdb_id',
        'rental_duration',
        'rental_price',
        'rental_type',
        'is_rental',
        'is_free'
    ];

    public function stars()
    {
        return $this->belongsToMany(Star::class);
    }

    public function quality()
    {
        return $this->belongsTo(VideoQuality::class, 'video_quality', 'id');
    }
    public function type()
    {
        return $this->belongsTo(Category::class, 'video_type', 'id');
    }
    public function playLists()
    {
        return $this->belongsToMany(PlayList::class, 'play_list_movies')->withTimestamps();
    }
    public function favoritedByUsers()
    {
        return $this->belongsToMany(User::class, 'favorite_movies');
    }
    public function reviews()
    {
        return $this->morphMany(Review::class, 'reviewable');
    }
    public function downloadLinks()
    {
        return $this->morphMany(DownloadLink::class, 'downloadable');
    }
    public function isFavoritedByLoggedInUser()
    {
        return $this->favoritedByUsers->contains(auth()->id());
    }
}
