<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomerQueryReply extends Model
{
    protected $fillable = [
        'customer_query_id',
        'admin_id',
        'reply'
    ];

    public function customerQuery()
    {
        return $this->belongsTo(CustomerQuery::class, 'customer_query_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

}
