<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'status',
        'description',
        'category_id',
        'image',
        'seo_title',
        'meta_description',
        'focus_keyword',
        'tags',
        'is_top',
    ];

    public function category()
    {
        return $this->belongsTo(BlogCategory::class, 'category_id', 'id');
    }
    public function reviews()
    {
        return $this->morphMany(Review::class, 'reviewable');
    }
}
