<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MovieMinimalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id' => $this->id,
            'title' => $this->title,
            'thumbnail' => $this->thumbnail,
            'poster' => $this->poster,
            'is_free' => (bool) $this->is_free,
            'is_rental' => (bool) $this->is_rental,
            'price' => get_currency($this->rental_price),
            'validity' => validity($this->rental_duration),
            'expire_data' => Carbon::now()->copy()->addHours($this->rental_duration)->format('Y-m-d H:i:s'),
            'tags' => $this->video_tags ?? [],
        ];
        ;
    }
}
