<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdatePlayListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('play_lists')->where(function ($query) {
                    return $query->where('user_id', $this->user_id);
                })->ignore($this->id),
            ],
            'user_id' => 'nullable|exists:users,id',
            'thumbnail' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:20480',
        ];
        return $rules;
    }
    public function messages()
    {
        return [
            'name.unique' => 'The playlist name has already been taken.',
            'name.required' => 'The name of the playlist is required.',
            'thumbnail.image' => 'Each thumbnail must be an image.',
        ];
    }
}
