<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;

class ReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'reportable_type' => 'required|string|in:App\Models\Movie,App\Models\TvShow',
            'reportable_id' => [
                'required',
                'integer',
                function ($attribute, $value, $fail) {
                    $type = $this->input('reportable_type');
                    if (!class_exists($type)) {
                        return $fail(__('invalid_model_type'));
                    }

                    if (!app($type)::where('id', $value)->exists()) {
                        return $fail(__('invalid_reportable_id'));
                    }
                },
            ],
            'video_issue' => 'nullable|in:broken,wrong_movie,others',
            'audio_issue' => 'nullable|in:not_synced,wrong_audio,others',
            'subtitle_issue' => 'nullable|in:not_synced,wrong_subtitle,missing_subtitle,others',
            'message' => 'nullable|string|max:1000',
        ];
    }
}
