<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class StarRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {

        return [
            'star_name' => 'required|string|max:50',
            'star_type' => 'required|max:191',
            'star_desc' => 'nullable|max:191',
            'star_image' => 'nullable|file|mimes:jpg,jpeg,png|max:20480',
            'slug' => 'nullable',
            'country_id' => 'nullable',
            'star_dob' => 'nullable|date',
            'ranking' => 'nullable|string|max:191',
            'gender' => 'nullable|string|max:191',
            'industries' => 'nullable|max:191',
        ];
    }
}