<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class StaffRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'first_name' => 'required|string|max:150',
            'last_name'  => 'required|string|max:191',
            'phone'      => 'required|string|max:191',
            'gender'      => 'required|integer|max:191',
            'email'      => 'required|email|max:191|unique:users,email,'.$this->id,
            'password'      => 'nullable|min:6',
            'image'      => 'nullable|file|mimes:jpg,jpeg,png|max:20480',
            'role_id'      => 'required|integer|max:20',
        ];
    }
}