<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class PackageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'name' => 'required|string|max:50',
            'day'  => 'required|max:10',
            'screens'      => 'required|integer|max:10',
            'price'      => 'required|integer|max:10',
            'status'      => 'nullable|integer|max:10',
            'type'      => 'required|accepted',
            'discount' => 'nullable|max:10',
        ];
    }
}