<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class LiveTvRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'tv_name' => 'required|string|max:150',
            'slug'  => 'nullable|string|max:191',
            'description'      => 'nullable|string|max:500',
            'category'      => 'required|integer|max:10',
            'status'      => 'nullable|max:10',
            'featured'      => 'nullable|max:10',
            'seo_title'      => 'nullable|string|max:191',
            'meta_description'      => 'nullable|string|max:255',
            'focus_keyword'      => 'nullable|string|max:191',
            'tags'      => 'nullable|max:191',
            'thumbnail'     => 'nullable|file|mimes:jpg,jpeg,png,mp4|max:20480',
        ];
    }
}