<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'video_type' => 'required|string|max:50',
            'video_type_desc'  => 'required|max:191',
            'primary_menu'      => 'nullable|integer|20',
            'footer_menu'      => 'nullable|integer|20',
            'slug'      => 'nullable|string|max:191',
            'order'      => 'nullable|integer|20',
        ];
    }
}