<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class BlogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'title' => 'required|string|max:191',
            'slug' => 'required|string|max:191',
            'category_id' => 'required|string|max:191',
            'description'      => 'nullable|string|max:500',
            'status'      => 'nullable|integer|max:20',
            'blog_banner'      => 'nullable|file|mimes:jpg,jpeg,png|max:20480',
            'seo_title'      => 'nullable|string|max:50',
            'meta_description'      => 'nullable|string|max:191',
            'focus_keyword'      => 'nullable|string|max:191',
            'tags'      => 'nullable|string|max:191',
        ];
    }
}