<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Episode;
use App\Repositories\Interfaces\Website\HomeRepositoryInterface;
use Illuminate\Http\Request;

class TvSeriesController extends Controller
{
    protected $homeRepository;

    public function __construct(HomeRepositoryInterface $homeRepository)
    {
        $this->homeRepository = $homeRepository;
    }

    public function all_tv_series(Request $request, $type)
    {
        $allowedTypes = ['blockbuster', 'new-release', 'recommended', 'featured', 'real-life-story', 'latest', 'top-rating', 'popular'];

        if (!in_array($type, $allowedTypes)) {
            abort(404);
        }

        $page_data = $this->homeRepository->all_tv_series($request, $type);

        return view('website.tv_show.list', $page_data);
    }

    public function tv_series()
    {

        $page_data = $this->homeRepository->tv_series();

        return view('website.tv_show.index', $page_data);
    }

    public function series_details($slug = null)
    {
        $page_data = $this->homeRepository->series_details($slug);
        return view('website.tv_show.details', $page_data);
    }

    public function watch_episode($slug = null) {

        $page_data = $this->homeRepository->video_player($slug, 'episode', null);

        $page_data['video_type'] = 'episode';
        return view('website.player.video_player', $page_data);
    }
}
