<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ReviewRequest;
use App\Models\Blog;
use App\Models\LiveTv;
use App\Models\Movie;
use App\Models\TvShow;
use App\Repositories\Interfaces\Admin\ReviewInterface;
use Exception;
use Illuminate\Support\Facades\Log;

class ReviewController extends Controller
{
    protected $reviewRepo;

    public function __construct(ReviewInterface $reviewRepo)
    {
        $this->reviewRepo = $reviewRepo;
    }

    public function storeMovieReview(ReviewRequest $request, Movie $movie)
    {
        try {
            $this->reviewRepo->createFor($movie, $request->all());

            return redirect()->back()->with('success_message', __('review_submitted'));
        } catch (Exception $e) {
            Log::error('Review store failed', ['error' => $e->getMessage()]);
            return redirect()->back()->with('error_message', __('failed_to_submit_review'));
        }
    }
    public function storeTvShowReview(ReviewRequest $request, TvShow $tvShow)
    {
        try {
            $this->reviewRepo->createFor($tvShow, $request->all());

            return redirect()->back()->with('success_message', __('review_submitted'));
        } catch (Exception $e) {
            Log::error('Review store failed', ['error' => $e->getMessage()]);
            return redirect()->back()->with('error_message', __('failed_to_submit_review'));
        }
    }
    public function storeBlogReview(ReviewRequest $request, Blog $blog)
    {
        try {
            $this->reviewRepo->createFor($blog, $request->all());

            return redirect()->back()->with('success_message', __('review_submitted'));
        } catch (Exception $e) {
            Log::error('Review store failed', ['error' => $e->getMessage()]);
            return redirect()->back()->with('error_message', __('failed_to_submit_review'));
        }
    }

    public function storeTvChannelReview(ReviewRequest $request, LiveTv $liveTv)
    {
        try {
            $this->reviewRepo->createFor($liveTv, $request->all());

            return redirect()->back()->with('success_message', __('review_submitted'));
        } catch (Exception $e) {
            Log::error('Review store failed', ['error' => $e->getMessage()]);
            return redirect()->back()->with('error_message', __('failed_to_submit_review'));
        }
    }

    public function toggleLike($id)
    {
        try {
            $review = \App\Models\Review::findOrFail($id);
            $user = auth()->user();

            if (!$user) {
                return response()->json([
                    'liked' => false,
                    'count' => $review->likes()->count(),
                    'error' => __('must_be_logged_in_to_like_review'),
                ], 401);
            }

            $like = $review->likes()->where('user_id', $user->id)->first();

            if ($like) {
                $like->delete();
                $liked = false;
            } else {
                $review->likes()->create(['user_id' => $user->id]);
                $liked = true;
            }

            return response()->json([
                'liked' => $liked,
                'count' => $review->likes()->count(),
            ]);
        } catch (\Exception $e) {
            Log::error('Toggle like failed', ['error' => $e->getMessage()]);
            return response()->json([
                'liked' => false,
                'count' => 0,
                'error' => __('failed_to_toggle_like')
            ], 500);
        } 
    }
}
