<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Ads;
use App\Models\Country;
use App\Models\Genre;
use App\Models\Movie;
use App\Models\MovieFile;
use App\Models\MovieLanguage;
use App\Models\Star;
use App\Models\TvShow;
use App\Repositories\Interfaces\Admin\CustomerQueryInterface;
use App\Repositories\Interfaces\Admin\MovieRequestInterface;
use App\Repositories\Interfaces\Admin\ReportInterface;
use App\Repositories\Interfaces\Website\HomeRepositoryInterface;
use Carbon\Carbon;
use Illuminate\Http\Request;

class MovieController extends Controller
{
    protected $contactUsRepo;
    protected $moveiRequestRepo;
    protected $reportRepo;
    protected $homeRepository;

    public function __construct(CustomerQueryInterface $contactUsRepo, MovieRequestInterface $moveiRequestRepo, ReportInterface $reportRepo, HomeRepositoryInterface $homeRepository)
    {
        $this->contactUsRepo = $contactUsRepo;
        $this->moveiRequestRepo = $moveiRequestRepo;
        $this->reportRepo = $reportRepo;
        $this->homeRepository = $homeRepository;
    }
    public function index(Request $request)
    {

        $page_data = $this->homeRepository->index($request);

        if($request->search) {
            return view('website.movie.list', $page_data);
        }
        
        return view('website.movie.index', $page_data);
    }

    public function all_movies(Request $request, $type)
    {
        $allowedTypes = ['latest', 'top-view', 'top-rating', 'trending', 'recommended', 'featured', 'blockbuster', 'real-life-story', 'popular'];

        if (!in_array($type, $allowedTypes)) {
            abort(404);
        }
        
        $page_data = $this->homeRepository->all_movies($request, $type);

        return view('website.movie.list', $page_data);
    }

    public function genre_wise_movie(Request $request, $slug)
    {
        $genre_ids = Genre::where('slug', $slug)->pluck('id')->toArray();
        if (count($genre_ids) <= 0) {
            abort(404);
        }

        $page_data = $this->homeRepository->genre_wise_movie($request, $genre_ids, $slug);

        return view('website.movie.list', $page_data);
    }

    public function country_wise_movie(Request $request, $slug)
    {

        $country_ids = Country::where('slug', $slug)->pluck('id')->toArray();
        if (count($country_ids) <= 0) {
            abort(404);
        }

        $page_data = $this->homeRepository->country_wise_movie($request, $country_ids, $slug);

        return view('website.movie.list', $page_data);
    }

    public function movie_details($slug = null)
    {
        $page_data = $this->homeRepository->movie_details($slug);

        return view('website.movie.details', $page_data);
    }

    public function watch_movie($slug = null, $key = null) {

        $page_data = $this->homeRepository->video_player($slug, 'movie', $key);

        if($key) {
            $page_data['server'] = MovieFile::where('stream_key', $key)->first();
        }
        $page_data['video_type'] = 'movie';
        return view('website.player.video_player', $page_data);
    }

    
}
