<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\TvShowDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\TvShowRequest;
use App\Models\Category;
use App\Models\Country;
use App\Models\Genre;
use App\Models\MovieLanguage;
use App\Models\Star;
use App\Models\TvShow;
use App\Models\VideoQuality;
use App\Repositories\Admin\TvShowRepository;
use App\Repositories\Interfaces\Admin\TvShowInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class TvShowController extends Controller
{
    protected $tv_shows;
    use ImageTrait;

    public function __construct(TvShowInterface $tv_shows)
    {
        $this->tv_shows = $tv_shows;
    }

    public function index(TvShowDataTable $dataTable)
    {
        return $dataTable->render('admin.tv_show.index');
    }

    public function add()
    {
        $page_data['categories'] = Category::get();
        $page_data['stars'] = Star::get();
        $page_data['countries'] = Country::get();
        $page_data['genres'] = Genre::where('status', 1)->get();
        $page_data['languages'] = MovieLanguage::where('status', 1)->get();
        $page_data['video_qualities'] = VideoQuality::where('status', 1)->get();
        return view('admin.tv_show.add', $page_data);
    }

    public function store(TvShowRequest $request)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.tv.shows');
        }
        $this->tv_shows->store($request->all());
        session()->flash('toastr_success', 'tv_show_create_successful!');
        return redirect()->route('admin.tv.shows');
    }


    public function edit($id)
    {
        $page_data['categories'] = Category::get();
        $page_data['stars'] = Star::get();
        $page_data['countries'] = Country::get();
        $page_data['genres'] = Genre::where('status', 1)->get();
        $page_data['languages'] = MovieLanguage::where('status', 1)->get();
        $page_data['video_qualities'] = VideoQuality::where('status', 1)->get();
        $page_data['tv_show'] = TvShow::where('id', $id)->first();
        return view('admin.tv_show.edit', $page_data);
    }

    public function update(TvShowRequest $request, $id)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.tv.shows');
        }
        $this->tv_shows->update($request->all(), $id);
        session()->flash('toastr_success', 'tv_show_update_successful!');
        return redirect()->route('admin.tv.shows');
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.tv.shows');
        }
        $this->imageDelete($id, 'tvShow', 'thumbnail');
        $showDelete = TvShow::where('id', $id)->delete();
        if ($showDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('tv_show_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }

    public function settings()
    {
        return view('admin.tv_show.settings');
    }

    public function config(Request $request)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.tv.shows');
        }
        $this->tv_shows->config($request->all());
        session()->flash('toastr_success', 'config_update_successful!');
        return redirect()->back();
    }
}
