<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\RentalHistoryDataTable;
use App\DataTables\Admin\SubscriptionDataTable;
use App\DataTables\Admin\TransactionLogDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PGRequest;
use App\Http\Requests\Admin\SubscriptionRequest;
use App\Models\Client;
use App\Models\Package;
use App\Models\RentalHistory;
use App\Models\Subscription;
use App\Repositories\Admin\SettingRepository;
use App\Repositories\Interfaces\Admin\SettingInterface;
use App\Repositories\Interfaces\Website\SubscriptionRepositoryInterface;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class SubscriptionController extends Controller
{
    protected $setting;
    protected $subscriptionRepository;

    public function __construct(SettingInterface $setting, SubscriptionRepositoryInterface $subscriptionRepository)
    {
        $this->setting = $setting;
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function paymentGateways()
    {
        return view('admin.subscription.payment_gateways');
    }

    public function savePGSetting(PGRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->setting->update($request);

            $data = [
                'success' => __('update_successful'),
            ];

            return response()->json($data);
        } catch (\Exception $e) {
            $data = [
                'error' => __('something_went_wrong_please_try_again'),
            ];

            return response()->json($data);
        }
    }

    public function allSubscription(SubscriptionDataTable $dataTable) {
        return $dataTable->render('admin.subscription.index');
    }

    public function subscribeListStatus(Request $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->subscriptionRepository->subscribeListStatus($request, $id);

            $data = [
                'status'  => 'success',
                'message' => __('status_update_successfully'),
                'title'   => __('success'),
            ];

            return response()->json($data);
        } catch (\Exception $e) {
            $data = [
                'status'  => 'danger',
                'message' => $e->getMessage(),
                'title'   => __('error'),
            ];

            return response()->json($data);
        }
    }

    public function stopRecurring($id): JsonResponse
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->subscriptionRepository->stopRecurring($id);

            $data = [
                'status'    => 'success',
                'message'   => __('recurring_stopped_successfully'),
                'title'     => __('success'),
                'is_reload' => false,
            ];

            return response()->json($data);
        } catch (\Exception $e) {
            $data = [
                'status'    => 'success',
                'message'   => $e->getMessage(),
                'title'     => __('error'),
                'is_reload' => false,
            ];

            return response()->json($data);
        }
    }

    public function addSubscription() {
        $page_data['clients'] = Client::where('status', 1)->get();
        $page_data['packages'] = Package::where('status', 1)->get();
        return view('admin.subscription.add', $page_data);
    }

    public function storeSubscription(SubscriptionRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if (isDemoMode()) {
            return response()->json([
                'status' => false,
                'error'  => __('this_function_is_disabled_in_demo_server'),
                'title'  => 'error',
            ]);
        }
        try {
            $trx_id = 'offline-'.$request->transaction_id;
            $plan   = Package::find($request->plan_id);
            $this->subscriptionRepository->create($request, $trx_id, $plan, '', true);
            return response()->json([
                'success' => __('create_successful'),
                'route'   => route('all.subscription'),
            ]);
        } catch (\Exception $e) {
            return response()->json(['status' => false,'error' => $e->getMessage()]);
        }
    }


    public function transactionLog(TransactionLogDataTable $dataTable) {
        return $dataTable->render('admin.subscription.transaction_log');
    }

    public function rentalHistory(RentalHistoryDataTable $dataTable) {
        return $dataTable->render('admin.subscription.rental_history');
    }

    public function rentListStatus($id, $status) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            RentalHistory::where('id', $id)->update(['status' => $status]);
            $data = [
                'status' => 'success',
                'message' => __('star_status_update_successfully'),
                'title' => __('success'),
                'reload' => false,
            ];
            return response()->json($data);
        } catch (Exception) {
            $data = [
                'status'    => 'error',
                'message'   => __('something_went_wrong'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
    }
}
