<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\DataTables\Admin\StarDataTable;
use App\Http\Requests\Admin\StarRequest;
use App\Models\Star;
use App\Repositories\Interfaces\Admin\StarInterface;
use Exception;
use Illuminate\Http\Request;
use Log;
use App\Traits\ImageTrait;

class StarController extends Controller
{
    protected $stars;
    use ImageTrait;

    public function __construct(StarInterface $stars)
    {
        $this->stars = $stars;
    }

    public function index(StarDataTable $dataTable)
    {
        return $dataTable->render('admin.star.index');
    }

    public function add()
    {
        return view('admin.star.add');
    }

    public function edit($id)
    {
        $data['star'] = Star::where('id', $id)->first();
        return view('admin.star.edit', $data);
    }
    public function store(StarRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->stars->store($request->all());

            return response()->json([
                'status' => 'success',
                'message' => __('star_added_successfully'),
                'title' => __('success'),
                'is_reload' => true,
            ]);
        } catch (Exception $e) {
            Log::error($e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => __('something_went_wrong'),
                'title' => __('error'),
            ], 500);
        }
    }
    public function update(StarRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->stars->update($request->all(), $id);

            return response()->json([
                'status' => 'success',
                'message' => __('star_update_successfully'),
                'title' => __('success'),
                'is_reload' => true,
            ]);
        } catch (Exception $e) {
            Log::error($e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => __('something_went_wrong'),
                'title' => __('error'),
            ], 500);
        }
    }


    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Star::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('star_status_update_successfully'),
            'title' => __('success'),
            'reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->imageDelete($id, 'star', 'star_image'); // param(id, model, column)
        $starDelete = Star::where('id', $id)->delete();
        if ($starDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('star_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
