<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\MovieRequestDataTable;
use App\Http\Controllers\Controller;
use App\Repositories\Interfaces\Admin\MovieRequestInterface;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class MovieRequestController extends Controller
{
    protected $repo;

    public function __construct(MovieRequestInterface $repo)
    {
        $this->repo = $repo;
    }

    public function index(MovieRequestDataTable $dataTable)
    {
        return $dataTable->render('admin.movie_requests.index');
    }
    public function update(Request $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->repo->update($id, $request->only('status'));

            $data = [
                'status' => 'success',
                'message' => __('status_updated_successfully'),
                'title' => __('success'),
            ];
            return response()->json($data);
        } catch (Exception $e) {
            Log::error(__('status_update_failled'), [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
                'data' => $request->all(),
            ]);

            $data = [
                'status' => 'error',
                'message' => __('status_update_failled'),
                'title' => __('error'),
            ];
            return response()->json($data);
        }
    }
    public function destroy($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
       
        try {
            $this->repo->delete($id);

            $data = [
                'status' => 'success',
                'message' => __('movie_request_deleted_successfully'),
                'title' => __('success'),
            ];
            return response()->json($data);
        } catch (Exception $e) {
            Log::error(__('movie_request_delete_failed'), [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            $data = [
                'status' => 'error',
                'message' => __('movie_request_delete_failed'),
                'title' => __('error'),
            ];
            return response()->json($data);
        }

    }
}
