<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\InterestDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\InterestRequest;
use App\Models\Interest;
use App\Repositories\Interfaces\Admin\InterestInterface;
use Illuminate\Http\Request;

class InterestController extends Controller
{
    protected $interests;

    public function __construct(InterestInterface $interests) {
        $this->interests = $interests;
    }

    public function index(InterestDataTable $dataTable) {
        return $dataTable->render('admin.interest.index');
    }

    public function add() {
        return view('admin.interest.add');
    }

    public function store(InterestRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->interests->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('interest_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['interest'] = Interest::where('id', $id)->first();
        return view('admin.interest.edit', $data);
    }

    public function update(InterestRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->interests->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('interest_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }


    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Interest::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('interest_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.interest.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $interestDelete = Interest::where('id', $id)->delete();
        if($interestDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('interest_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }


}
