<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Config;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class FooterSettingController extends Controller
{
    use ImageTrait;
    public function footerContent()
    {
        return redirect()->route('footer.primary-content');
    }

    public function primaryContentSetting()
    {
        return view('admin.website.footer_content.primary_content');
    }

    public function paymentbannerSetting()
    {
        return view('admin.website.footer_content.payment_banner');
    }


    public function helpCenterLinkSetting()
    {
        return view('admin.website.footer_content.help_center_links');
    }

    public function legalPagesLinkSetting()
    {
        return view('admin.website.footer_content.legal_pages_links');
    }

    public function copyrightSetting()
    {
        return view('admin.website.footer_content.copyright');
    }
    public function appLinks()
    {
        return view('admin.website.footer_content.app_links');
    }


    public function updateSetting(Request $request): \Illuminate\Http\JsonResponse
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            foreach ($request->all() as $key => $value) {
                if ($key === '_token') {
                    continue;
                }

                if ($request->hasFile($key)) {
                    // Delete old image if exists
                    if (!blank(setting($key))) {
                        $this->deleteImage(setting($key));
                    }

                    // Save the new image
                    $response = $this->saveImage($request->file($key), $key);
                    $value = json_encode($response['images']);
                }

                // Update or create the config entry
                Config::updateOrCreate(
                    ['title' => $key],
                    ['value' => $value]
                );
            }
            $data = [
                'status' => 'success',
                'message' => __('setting_updated_successfully'),
                'title' => __('success'),
                'is_reload' => false,
            ];
            return response()->json($data);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => __('setting_updated_unsuccessfull'),
                'title' => __('error'),
                'is_reload' => false,
            ]);
        }
    }


    public function socialLink()
    {
        return view('admin.website.footer_content.social-link');
    }

}
