<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\FaqDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\FaqRequest;
use App\Models\Faq;
use App\Repositories\Interfaces\Admin\FaqInterface;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    protected $faqs;

    public function __construct(FaqInterface $faq) {
        $this->faqs = $faq;
    }

    public function index(FaqDataTable $dataTable) {
        return $dataTable->render('admin.faq.index');
    }

    public function add() {
        return view('admin.faq.add');
    }

    public function store(FaqRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->faqs->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('faq_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['faq'] = Faq::where('id', $id)->first();
        return view('admin.faq.edit', $data);
    }

    public function update(FaqRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->faqs->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('faq_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Faq::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('faq_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.faq.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $faqDelete = Faq::where('id', $id)->delete();
        if($faqDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('faq_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }

}
