<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\DataTables\Admin\CategoryDataTable;
use App\Http\Requests\Admin\CategoryRequest;
use App\Models\Category;
use App\Repositories\Interfaces\Admin\CategoryInterface;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    protected $categories;

    public function __construct(CategoryInterface $categories)
    {
        $this->categories = $categories;
    }

    public function index(CategoryDataTable $dataTable)
    {
        return $dataTable->render('admin.category.index');
    }

    public function add()
    {
        return view('admin.category.add');
    }

    public function store(CategoryRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->store($request->all());
        $data = [
            'status' => 'success',
            'message' => __('category_added_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {
        $data['category'] = Category::where('id', $id)->first();
        return view('admin.category.edit', $data);
    }

    public function update(CategoryRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->update($request->all(), $id);
        $data = [
            'status' => 'success',
            'message' => __('category_update_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function footer_menu(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Category::where('id', $request->id)->update(['footer_menu' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('footer_menu_status_update_successfully'),
            'title' => __('success'),
            'reload' => false,
        ];
        return response()->json($data);
    }

    public function primary_menu(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Category::where('id', $request->id)->update(['primary_menu' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('primary_menu_status_update_successfully'),
            'title' => __('success'),
            'reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.category.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $categoryDelete = Category::where('id', $id)->delete();
        if ($categoryDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('category_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}