<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ApiKeyRequest;
use App\Models\ApiKey;
use App\Repositories\Interfaces\Admin\SettingInterface;
use Illuminate\Http\Request;

class ApiKeyController extends Controller
{
    protected $setting;

    public function __construct(SettingInterface $setting)
    {
        $this->setting = $setting;
    }

    public function adSettings()
    {
        return view('admin.settings.mobile_api.ad_settings');
    }

    public function apiSettings()
    {
        $page_data['api_keys'] = ApiKey::get();
        return view('admin.settings.mobile_api.api_settings', $page_data);
    }

    public function add()
    {
        return view('admin.settings.mobile_api.add');
    }

    public function store(ApiKeyRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->setting->apiKeyStore($request);
        $data = [
            'status' => 'success',
            'message' => __('api_key_added_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {
        $data['api_key'] = ApiKey::where('id', $id)->first();
        return view('admin.settings.mobile_api.edit', $data);
    }

    public function status($id, $status){
        if (isDemoMode()) {
           return redirect()->back()->with('toastr_error', 'This action is disabled in demo mode.');
        }
        $status = ApiKey::where('id', $id)->update(['status' => $status == 1 ? 0 : 1]);
        if($status) {
            return redirect()->back()->with('toastr_success', __('api_key_status_change_successfully'));
        }
        return redirect()->back()->with('toastr_error', __('something_wrong'));
        
    }

    public function update(ApiKeyRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->setting->apiKeyUpdate($request, $id);
        $data = [
            'status' => 'success',
            'message' => __('api_key_update_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('apikeys.edit')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $faqDelete = ApiKey::where('id', $id)->delete();
        if($faqDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('api_key_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }



}
