<?php

namespace App\DataTables\Admin;

use App\Models\VideoQuality;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class VideoQualityDataTable extends DataTable
{
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('quality', function ($quality) {
                return $quality->quality;
            })
            ->addColumn('description', function ($quality) {
                return $quality->description;
            })
            ->addColumn('status', function ($quality) {
                return view('admin.video_quality.status', compact('quality'));
            })
            ->addColumn('option', function ($quality) {
                return view('admin.video_quality.action', compact('quality'));
            })
            ->setRowId('id');
    }

    public function query(): QueryBuilder
    {
        return VideoQuality::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('quality', 'like', "%$search%");
        })
            ->latest()
            ->newQuery();
    }

    public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ ' . __('video_quality_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
            Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('quality')->title(__('quality')),
            Column::computed('description')->title(__('description')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),

        ];
    }

    protected function filename(): string
    {
        return 'Currency_' . date('YmdHis');
    }
}
